<?php include 'header.php'; ?>
<!-- END nav -->

<!-- ========== ABOUT HERO (UNIQUE LAYOUT) ========== -->
<section class="hero-wrap js-fullheight" 
	style="background-image:url('images/bg_1.jpg'); background-size:cover; background-position:center; position:relative;">
	
	<!-- Overlay -->
	<div style="position:absolute; inset:0; background:linear-gradient(120deg, rgba(0,0,0,0.75), rgba(0,0,0,0.35));"></div>
	
	<div class="container h-100" style="position:relative; z-index:2;">
		<div class="row h-100 no-gutters align-items-center">
			
			<!-- Left: Text -->
			<div class="col-md-7 ftco-animate">
				<p class="breadcrumbs" style="margin-bottom:10px; font-size:13px; color:#e0e0e0;">
					<span class="mr-2">
						<a href="home.php" style="color:#ffffff; text-decoration:none;">
							Home <i class="fa fa-chevron-right"></i>
						</a>
					</span>
					<span>About Us <i class="fa fa-chevron-right"></i></span>
				</p>
				<h1 class="mb-3" 
					style="font-size:40px; font-weight:800; color:#ffffff;">
					About Best Travel Destinations
				</h1>
				<p style="max-width:480px; color:#f0f0f0; font-size:15px; line-height:1.8;">
					We design thoughtful journeys across Asia and beyond, blending iconic landmarks with hidden local gems so every trip feels personal, seamless, and unforgettable.
				</p>
			</div>

			<!-- Right: Floating Stats Card -->
			<div class="col-md-5 d-none d-md-block">
				<div class="ftco-animate"
					style="
						margin-left:auto;
						background:rgba(10,25,41,0.8);
						backdrop-filter:blur(14px);
						-webkit-backdrop-filter:blur(14px);
						border-radius:18px;
						padding:22px 22px 20px 22px;
						box-shadow:0 16px 40px rgba(0,0,0,0.45);">
					
					<p style="font-size:13px; text-transform:uppercase; letter-spacing:1px; color:#FFC107; margin-bottom:8px;">
						Your Journey, Our Expertise
					</p>
					<h3 style="font-size:20px; font-weight:700; color:#ffffff; margin-bottom:16px;">
						Trusted Travel Partner Across Asia
					</h3>

					<div style="display:flex; justify-content:space-between; gap:10px; margin-bottom:16px;">
						<div>
							<p style="margin:0; font-size:12px; text-transform:uppercase; letter-spacing:1px; color:#a0b5d8;">
								Years in Travel
							</p>
							<p style="margin:2px 0 0 0; font-size:22px; font-weight:700; color:#ffffff;">10+</p>
						</div>
						<div>
							<p style="margin:0; font-size:12px; text-transform:uppercase; letter-spacing:1px; color:#a0b5d8;">
								Trips Planned
							</p>
							<p style="margin:2px 0 0 0; font-size:22px; font-weight:700; color:#ffffff;">15K+</p>
						</div>
						<div>
							<p style="margin:0; font-size:12px; text-transform:uppercase; letter-spacing:1px; color:#a0b5d8;">
								Asian Spots
							</p>
							<p style="margin:2px 0 0 0; font-size:22px; font-weight:700; color:#ffffff;">40+</p>
						</div>
					</div>

					<p style="margin:0; font-size:13px; color:#d0d8e8; line-height:1.6;">
						From first inspiration to your flight home, we’re here with curated stays, seamless transfers, and local experts at every step.
					</p>
				</div>
			</div>

		</div>
	</div>
</section>

<!-- ========== WHAT WE DO (3-COLUMN BAND, UNIQUE) ========== -->
<section class="ftco-section" style="background:#f5f7fb; padding:70px 0 60px 0;">
	<div class="container">
		<div class="row justify-content-center pb-4">
			<div class="col-md-10 text-center ftco-animate">
				<span style="
					display:inline-block;
					padding:6px 18px;
					border-radius:999px;
					background:rgba(30,136,229,0.08);
					color:#1E88E5;
					font-size:13px;
					font-weight:600;
					letter-spacing:1px;
					text-transform:uppercase;">
					What We Create
				</span>
				<h2 style="margin-top:16px; margin-bottom:10px; font-size:30px; font-weight:800; color:#222;">
					Journeys Designed Around Real Travelers
				</h2>
				<p style="max-width:620px; margin:0 auto; color:#666; font-size:15px; line-height:1.7;">
					We go beyond standard tour packages, building experiences that reflect how you like to travel—whether that’s slow, immersive, luxurious, or adventure-packed.
				</p>
			</div>
		</div>

		<div class="row">
			<!-- Card 1 -->
			<div class="col-md-4 ftco-animate" style="margin-bottom:24px;">
				<div style="
					background:#ffffff;
					border-radius:18px;
					padding:22px 20px 20px 20px;
					box-shadow:0 10px 26px rgba(0,0,0,0.08);
					height:100%;">
					<div style="width:46px; height:46px; border-radius:50%; background:rgba(30,136,229,0.1); display:flex; align-items:center; justify-content:center; margin-bottom:12px;">
						<span class="flaticon-map" style="font-size:22px; color:#1E88E5;"></span>
					</div>
					<h3 style="font-size:18px; font-weight:700; margin-bottom:8px; color:#222;">
						Signature Itineraries
					</h3>
					<p style="margin:0; font-size:14px; color:#555; line-height:1.6;">
						Balanced routes that weave together must-see sights, downtime, and unexpected local moments.
					</p>
				</div>
			</div>

			<!-- Card 2 -->
			<div class="col-md-4 ftco-animate" style="margin-bottom:24px;">
				<div style="
					background:#ffffff;
					border-radius:18px;
					padding:22px 20px 20px 20px;
					box-shadow:0 10px 26px rgba(0,0,0,0.08);
					height:100%;">
					<div style="width:46px; height:46px; border-radius:50%; background:rgba(255,193,7,0.12); display:flex; align-items:center; justify-content:center; margin-bottom:12px;">
						<span class="flaticon-tour-guide" style="font-size:22px; color:#FFC107;"></span>
					</div>
					<h3 style="font-size:18px; font-weight:700; margin-bottom:8px; color:#222;">
					Local Expertise
					</h3>
					<p style="margin:0; font-size:14px; color:#555; line-height:1.6;">
					Handpicked guides and partners who reveal the stories, traditions, and flavors you won’t find in guidebooks.
					</p>
				</div>
			</div>

			<!-- Card 3 -->
			<div class="col-md-4 ftco-animate" style="margin-bottom:24px;">
				<div style="
					background:#ffffff;
					border-radius:18px;
					padding:22px 20px 20px 20px;
					box-shadow:0 10px 26px rgba(0,0,0,0.08);
					height:100%;">
					<div style="width:46px; height:46px; border-radius:50%; background:rgba(30,136,229,0.1); display:flex; align-items:center; justify-content:center; margin-bottom:12px;">
						<span class="flaticon-route" style="font-size:22px; color:#1E88E5;"></span>
					</div>
					<h3 style="font-size:18px; font-weight:700; margin-bottom:8px; color:#222;">
					Seamless Planning
					</h3>
					<p style="margin:0; font-size:14px; color:#555; line-height:1.6;">
					Flights, transfers, stays, and experiences—all coordinated so you can focus purely on the journey.
					</p>
				</div>
			</div>
		</div>
	</div>
</section>

<!-- ========== WHY TRAVEL WITH US (NEW LAYOUT) ========== -->
<section class="ftco-section ftco-about img" style="background:#ffffff; padding-top:10px; padding-bottom:80px;">
	<div class="container">
		<div class="row d-flex align-items-center">
			
			<!-- Left: Image block (tall card) -->
			<div class="col-md-5 ftco-animate" style="margin-bottom:24px;">
				<div style="
					border-radius:24px;
					overflow:hidden;
					box-shadow:0 16px 36px rgba(0,0,0,0.16);
					position:relative;">
					
					<div style="
						background-image:url('images/about-1.jpg');
						background-size:cover;
						background-position:center;
						height:380px;">
					</div>

					<!-- Small overlay tag at bottom -->
					<div style="
						position:absolute;
						left:16px;
						bottom:16px;
						padding:8px 14px;
						border-radius:999px;
						background:rgba(0,0,0,0.65);
						color:#ffffff;
						font-size:12px;">
						<span class="fa fa-plane" style="margin-right:6px; color:#FFC107;"></span>
						Asia-Focused Travel Specialists
					</div>
				</div>
			</div>

			<!-- Right: Text content -->
			<div class="col-md-7 ftco-animate">
				<div class="heading-section" style="margin-bottom:14px;">
					<span style="
						display:inline-block;
						padding:5px 14px;
						border-radius:999px;
						background:rgba(30,136,229,0.08);
						color:#1E88E5;
						font-size:12px;
						font-weight:600;
						letter-spacing:0.8px;
						text-transform:uppercase;">
						Why Travel With Us
					</span>

					<h2 style="
						margin-top:16px;
						margin-bottom:10px;
						font-size:26px;
						font-weight:800;
						color:#222;">
						Curated Asian Journeys, Crafted Around You
					</h2>
				</div>

				<p style="font-size:14px; color:#555; line-height:1.7; margin-bottom:10px;">
					Step into a world where ancient heritage meets contemporary marvels. From the serene shores of Bali 
					to the neon-lit skyline of Tokyo, we design trips that match how you want to feel while traveling.
				</p>

				<p style="font-size:14px; color:#555; line-height:1.7; margin-bottom:18px;">
					We collaborate with trusted local experts to uncover hidden streets, sunrise viewpoints, night markets, 
					and boutique stays—so every journey feels both effortless and deeply memorable.
				</p>

				<!-- Stats row -->
				<div style="display:flex; flex-wrap:wrap; gap:14px; margin-bottom:18px;">
					<div style="flex:1 1 120px; min-width:120px;">
						<p style="margin:0; font-size:12px; text-transform:uppercase; letter-spacing:1px; color:#888;">
							Years of Expertise
						</p>
						<p style="margin:2px 0 0 0; font-size:22px; font-weight:700; color:#1E88E5;">
							10+
						</p>
					</div>
					<div style="flex:1 1 120px; min-width:120px;">
						<p style="margin:0; font-size:12px; text-transform:uppercase; letter-spacing:1px; color:#888;">
							Trips Planned
						</p>
						<p style="margin:2px 0 0 0; font-size:22px; font-weight:700; color:#1E88E5;">
							15K+
						</p>
					</div>
					<div style="flex:1 1 120px; min-width:120px;">
						<p style="margin:0; font-size:12px; text-transform:uppercase; letter-spacing:1px; color:#888;">
							Asian Destinations
						</p>
						<p style="margin:2px 0 0 0; font-size:22px; font-weight:700; color:#1E88E5;">
							40+
						</p>
					</div>
				</div>

				<!-- Bullet icons / highlights -->
				<div style="display:flex; flex-direction:column; gap:6px; margin-bottom:14px;">
					<div style="font-size:14px; color:#555;">
						<span class="fa fa-check-circle" style="color:#1E88E5; margin-right:6px;"></span>
						Personalized itineraries tailored to your pace and interests.
					</div>
					<div style="font-size:14px; color:#555;">
						<span class="fa fa-check-circle" style="color:#1E88E5; margin-right:6px;"></span>
						Trusted local partners, boutique stays, and curated experiences.
					</div>
					<div style="font-size:14px; color:#555;">
						<span class="fa fa-check-circle" style="color:#1E88E5; margin-right:6px;"></span>
						End-to-end planning so you can simply enjoy the journey.
					</div>
				</div>

				<p style="margin:0;">
					<a href="asia.php" 
					   class="btn btn-primary py-3 px-5 mt-2"
					   style="
							background:#1E88E5;
							border-color:#1E88E5;
							border-radius:999px;
							font-weight:600;
							box-shadow:0 8px 22px rgba(30,136,229,0.35);">
						Begin Your Asian Odyssey
					</a>
				</p>

			</div>
		</div>
	</div>
</section>

<?php include 'footer.php'; ?>
