<?php
include('admin/conn.php');

$message = ""; // Initialize an empty message

if (isset($_POST['submit'])) {
  $name = $_POST['name'];
  $mail = $_POST['email'];
  $sub = $_POST['sub'];
  $message = $_POST['message'];
  $phone = $_POST['phone'];

  $stmt = $conn->prepare("INSERT INTO `apply_now`(`Name`, `sub`, `message`, `email`, `phone`, `Date`) VALUES (?, ?, ?, ?, ?, NOW())");
  $stmt->bind_param("sssss", $name, $sub, $message, $mail, $phone);
  
  if ($stmt->execute()) {
      $message = "Your details have been submitted successfully!";
  } else {
      $message = "There was an error submitting your details.";
  }

  $stmt->close();

  // Redirect to avoid form resubmission
  header("Location: " . $_SERVER['PHP_SELF']);
  exit();
}


?>


<?php include 'header.php'; ?>
 
 <!-- CONTACT HERO (new design) -->
<section class="contact-hero" style="background-image: url('images/bg_1.jpg');">
  <div class="contact-hero-overlay"></div>
  <div class="container h-100">
    <div class="row h-100 align-items-center justify-content-center text-center">
      <div class="col-md-10">
        <p class="breadcrumbs mb-2">
          <span class="mr-2">
            <a href="home.php">Home <i class="fa fa-chevron-right"></i></a>
          </span>
          <span>Contact Us <i class="fa fa-chevron-right"></i></span>
        </p>
        <h1 class="contact-hero-title mb-3">We’d Love to Hear From You</h1>
        <p class="contact-hero-subtitle mb-0">
          Share your travel plans, questions, or ideas and our team will get back to you shortly.
        </p>
      </div>
    </div>
  </div>
</section>

<!-- CONTACT INFO STRIP (cards) -->
<section class="ftco-section contact-strip" style="padding:40px 0; background:#ffffff;">
  <div class="container">
    <div class="row">

      <div class="col-md-4 mb-3">
        <div class="contact-info-card">
          <div class="contact-icon">
            <i class="fa fa-map-marker"></i>
          </div>
          <h3>Office Address</h3>
          <p>198 West 21th Street, Suite 721<br>New York, NY 10016</p>
        </div>
      </div>

      <div class="col-md-4 mb-3">
        <div class="contact-info-card">
          <div class="contact-icon">
            <i class="fa fa-phone"></i>
          </div>
          <h3>Call or WhatsApp</h3>
          <p><a href="tel://1234567920">+ 1235 2355 98</a><br>Mon – Sat, 9:00 AM – 7:00 PM</p>
        </div>
      </div>

      <div class="col-md-4 mb-3">
        <div class="contact-info-card">
          <div class="contact-icon">
            <i class="fa fa-envelope"></i>
          </div>
          <h3>Email & Website</h3>
          <p>
            <a href="mailto:info@besttraveldestinations.online">info@besttraveldestinations.online</a><br>
            <a href="https://besttraveldestinations.online/">besttraveldestinations.online</a>
          </p>
        </div>
      </div>

    </div>
  </div>
</section>

<!-- MAIN CONTACT SECTION (no map, new layout) -->
<section class="ftco-section contact-main" style="padding-top:0;">
  <div class="container">
    <div class="row block-9">
      
      <!-- FORM -->
      <div class="col-md-7 d-flex mb-4 mb-md-0">
        <form method="post" id="contactForm" class="bg-white p-4 p-md-5 contact-form contact-form-modern">
  <h3 class="mb-3">Send Us a Message</h3>
  <p class="mb-4" style="color:#6c757d; font-size:14px;">
    Planning a trip, need a custom itinerary, or just have a question? Fill in the form below and our
    travel specialists will connect with you.
  </p>

  <div class="form-group">
    <label>Your Name</label>
    <input type="text" class="form-control" placeholder="Enter full name" name="name" id="name">
  </div>

  <div class="form-row">
    <div class="form-group col-md-6">
      <label>Your Email</label>
      <input type="email" class="form-control" placeholder="you@example.com" name="email" id="email">
    </div>
    <div class="form-group col-md-6">
      <label>Mobile Number</label>
      <input type="text" class="form-control" placeholder="Include country code" name="phone" id="phone">
    </div>
  </div>

  <div class="form-group">
    <label>Subject</label>
    <input type="text" class="form-control" placeholder="Tell us what this is about" name="sub" id="sub">
  </div>

  <div class="form-group">
    <label>Your Message</label>
    <textarea cols="30" rows="6" class="form-control" placeholder="Share your travel plans or query here..." name="message" id="message"></textarea>
  </div>

  <div class="form-group mb-0">
    <input type="submit" id="submit" name="submit" value="Send Message" class="btn btn-primary py-3 px-5">
  </div>
</form>

      </div>
<!-- SweetAlert CDN -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.getElementById("contactForm").addEventListener("submit", function(e){
    e.preventDefault(); // stop default submission

    // Get values
    let name = document.getElementById("name").value.trim();
    let email = document.getElementById("email").value.trim();
    let phone = document.getElementById("phone").value.trim();
    let sub = document.getElementById("sub").value.trim();
    let message = document.getElementById("message").value.trim();

    // Validation
    if(name === "" || email === "" || phone === "" || sub === "" || message === ""){
        Swal.fire({
            icon: "error",
            title: "Missing Information",
            text: "Please fill in all fields before sending your message.",
        });
        return;
    }

    // SUCCESS SWEET ALERT
    Swal.fire({
        icon: "success",
        title: "Message Sent!",
        text: "Thank you for reaching out! Our travel team will contact you soon.",
        confirmButtonColor: "#1E88E5"
    }).then(() => {
        document.getElementById("contactForm").submit(); // submit form after alert
    });

});
</script>

      <!-- SIDE PANEL (replaces map) -->
      <div class="col-md-5 d-flex">
        <div class="contact-side-panel">
          <h4>Why Reach Out?</h4>
          <ul class="contact-list">
            <li><i class="fa fa-check"></i> Custom-made Asia itineraries</li>
            <li><i class="fa fa-check"></i> Hotel, flight & visa assistance</li>
            <li><i class="fa fa-check"></i> Best time to visit recommendations</li>
            <li><i class="fa fa-check"></i> Group, honeymoon & family packages</li>
          </ul>

          <h5 class="mt-4">Response Time</h5>
          <p style="font-size:14px; color:#6c757d;">
            We usually respond within <strong>24 business hours</strong>. For urgent queries, feel free to call or WhatsApp us directly.
          </p>

          <div class="contact-highlight mt-4">
            <span class="label">Need urgent help?</span>
            <p class="mb-1"><i class="fa fa-phone"></i> + 1235 2355 98</p>
            <p class="mb-0"><i class="fa fa-envelope"></i> support@besttraveldestinations.online</p>
          </div>
        </div>
      </div>

    </div>
  </div>
</section>

<style>
/* HERO */
.contact-hero{
  position:relative;
  background-size:cover;
  background-position:center;
  min-height:55vh;
  display:flex;
  align-items:center;
}
.contact-hero-overlay{
  position:absolute;
  inset:0;
  background:linear-gradient(135deg, rgba(0,0,0,0.7), rgba(0,0,0,0.35));
}
.contact-hero .container{
  position:relative;
  z-index:2;
}
.contact-hero-title{
  font-size:40px;
  font-weight:700;
  color:#fff;
}
.contact-hero-subtitle{
  color:rgba(255,255,255,0.85);
  max-width:600px;
  margin:0 auto;
}

/* CONTACT INFO CARDS */
.contact-info-card{
  background:#ffffff;
  border-radius:14px;
  padding:22px 20px;
  box-shadow:0 10px 25px rgba(0,0,0,0.06);
  text-align:left;
  display:flex;
  flex-direction:column;
  height:100%;
}
.contact-info-card h3{
  font-size:18px;
  margin-bottom:8px;
  font-weight:600;
}
.contact-info-card p{
  margin:0;
  color:#6c757d;
  font-size:14px;
}
.contact-info-card a{
  color:#1E88E5;
}
.contact-icon{
  width:40px;
  height:40px;
  border-radius:50%;
  background:#e8f2ff;
  display:flex;
  align-items:center;
  justify-content:center;
  color:#1E88E5;
  margin-bottom:10px;
  font-size:18px;
}

/* MAIN CONTACT SECTION */
.contact-form-modern{
  border-radius:18px;
  box-shadow:0 15px 35px rgba(0,0,0,0.08);
  border:1px solid #f1f1f1;
}
.contact-form-modern label{
  font-size:13px;
  font-weight:600;
  text-transform:uppercase;
  letter-spacing:.05em;
  color:#6c757d;
}
.contact-form-modern .form-control{
  border-radius:10px;
  font-size:14px;
}
.contact-main .btn-primary{
  border-radius:999px;
  padding-left:26px;
  padding-right:26px;
}

/* SIDE PANEL */
.contact-side-panel{
  background:#0d1b2a;
  color:#ffffff;
  border-radius:18px;
  padding:28px 24px;
  width:100%;
  box-shadow:0 15px 35px rgba(0,0,0,0.18);
}
.contact-side-panel h4{
  font-size:20px;
  margin-bottom:12px;
  font-weight:700;
}
.contact-side-panel h5{
  font-size:16px;
  font-weight:600;
}
.contact-list{
  list-style:none;
  padding:0;
  margin:0;
  font-size:14px;
}
.contact-list li{
  margin-bottom:8px;
  display:flex;
  align-items:flex-start;
}
.contact-list i{
  color:#4caf50;
  margin-right:8px;
  margin-top:2px;
}
.contact-highlight{
  background:rgba(255,255,255,0.06);
  border-radius:14px;
  padding:14px 14px 10px;
  font-size:14px;
}
.contact-highlight .label{
  display:inline-block;
  font-size:11px;
  text-transform:uppercase;
  letter-spacing:.08em;
  color:#ffc107;
  margin-bottom:4px;
}
.contact-highlight i{
  margin-right:6px;
}

/* Responsive */
@media (max-width:767.98px){
  .contact-hero-title{font-size:32px;}
  .contact-side-panel{margin-top:20px;}
}
</style>





<?php include 'footer.php'; ?>