<?php include "header.php"; ?>
	
	<div class="hero-wrap js-fullheight" 
     style="background-image:url('images/a.jpg'); background-size:cover; background-position:center; position:relative;">
  
  <!-- Soft gradient overlay -->
  <div style="
      position:absolute; 
      inset:0;
      background:radial-gradient(circle at top left, rgba(30,136,229,0.70), transparent 55%),
                 linear-gradient(to bottom, rgba(0,0,0,0.65), rgba(0,0,0,0.35));
      z-index:1;">
  </div>

  <div class="container" style="position:relative; z-index:2; height:100%;">
    <div class="row no-gutters js-fullheight align-items-center">
      
      <!-- LEFT: TEXT -->
      <div class="col-md-7 ftco-animate" style="padding-top:40px; padding-bottom:40px;">
        
        <span style="
          display:inline-block; 
          padding:6px 18px; 
          border-radius:999px; 
          background:rgba(255,255,255,0.12);
          color:#FFC107; 
          font-size:13px;
          font-weight:600;
          letter-spacing:1px;
          text-transform:uppercase;">
          Your Journey Starts Here
        </span>

        <h1 style="
          margin-top:20px; 
          margin-bottom:12px;
          font-size:50px; 
          font-weight:800; 
          line-height:1.2; 
          color:#ffffff;">
          Explore the Best Destinations Across Asia & Beyond
        </h1>

        <p style="
          color:#f2f2f2; 
          font-size:16px; 
          max-width:520px; 
          line-height:1.7;">
          From tropical islands to bustling cityscapes, discover stays and experiences carefully curated for modern travelers.
        </p>

        <div style="margin-top:18px; display:flex; flex-wrap:wrap; gap:10px;">
          <div style="font-size:13px; color:#e0e0e0;">
            <span class="fa fa-check-circle" style="color:#FFC107; margin-right:6px;"></span>
            Handpicked tours & stays
          </div>
          <div style="font-size:13px; color:#e0e0e0;">
            <span class="fa fa-check-circle" style="color:#FFC107; margin-right:6px;"></span>
            Trusted local experts
          </div>
        </div>

      </div>

      <!-- RIGHT: FLOATING SEARCH / CTA CARD -->
      <div class="col-md-5 ftco-animate d-none d-md-block">
        <div style="
          margin-left:auto;
          max-width:360px;
          background:rgba(10,25,41,0.70);
          border-radius:22px;
          padding:18px 20px 20px 20px;
          box-shadow:0 18px 40px rgba(0,0,0,0.55);
          backdrop-filter:blur(18px);
          -webkit-backdrop-filter:blur(18px);">
          
          <p style="
            margin:0 0 8px 0; 
            font-size:12px; 
            letter-spacing:1px; 
            text-transform:uppercase; 
            color:#FFC107;">
            Plan Your Escape
          </p>

          <h3 style="margin:0 0 14px 0; font-size:20px; font-weight:700; color:#ffffff;">
            Find Your Perfect Getaway
          </h3>

          <!-- Destination -->
        <!-- Include SweetAlert (required) -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<form id="travelForm">

  <div style="margin-bottom:10px;">
    <label style="display:block; font-size:12px; color:#aab7d4; margin-bottom:4px;">Destination</label>
    <input type="text" id="destination" placeholder="Where do you want to go?" 
           style="width:100%; padding:9px 10px; border-radius:10px; border:1px solid rgba(255,255,255,0.2); background:rgba(10,25,41,0.9); color:#ffffff; font-size:13px;">
  </div>

  <!-- Date & Duration -->
  <div style="display:flex; gap:8px; margin-bottom:10px;">
    <div style="flex:1;">
      <label style="display:block; font-size:12px; color:#aab7d4; margin-bottom:4px;">Month</label>
      <input type="text" id="month" placeholder="e.g. March"
             style="width:100%; padding:9px 10px; border-radius:10px; border:1px solid rgba(255,255,255,0.2); background:rgba(10,25,41,0.9); color:#ffffff; font-size:13px;">
    </div>
    <div style="flex:1;">
      <label style="display:block; font-size:12px; color:#aab7d4; margin-bottom:4px;">Duration</label>
      <input type="text" id="duration" placeholder="5–7 Days"
             style="width:100%; padding:9px 10px; border-radius:10px; border:1px solid rgba(255,255,255,0.2); background:rgba(10,25,41,0.9); color:#ffffff; font-size:13px;">
    </div>
  </div>

  <!-- Travel Type -->
  <div style="margin-bottom:12px;">
    <label style="display:block; font-size:12px; color:#aab7d4; margin-bottom:4px;">Travel Style</label>
    <select id="style"
            style="width:100%; padding:9px 10px; border-radius:10px; border:1px solid rgba(255,255,255,0.2); background:rgba(10,25,41,0.9); color:#ffffff; font-size:13px;">
      <option value="" style="color:#000;">Select Style</option>
      <option style="color:#000;">Adventure</option>
      <option style="color:#000;">Relax & Beach</option>
      <option style="color:#000;">City Escape</option>
      <option style="color:#000;">Cultural & Heritage</option>
    </select>
  </div>

  <!-- Button -->
  <button type="submit"
     style="display:block; width:100%; text-align:center; background:#1E88E5; color:#ffffff; padding:11px 10px; margin-top:4px; font-size:14px; font-weight:600; border-radius:999px; text-decoration:none; border:none; box-shadow:0 10px 26px rgba(30,136,229,0.5);">
    Start Planning Now
  </button>

</form>

          <!-- Small note -->
          <p style="margin:8px 0 0 0; font-size:11px; color:#aab7d4;">
            No instant booking here—we review your preferences and craft a tailored itinerary.
          </p>

        </div>
      </div>

    </div>
  </div>

</div>


<script>
document.getElementById("travelForm").addEventListener("submit", function(e){
    e.preventDefault();

    let dest = document.getElementById("destination").value.trim();
    let month = document.getElementById("month").value.trim();
    let duration = document.getElementById("duration").value.trim();
    let style = document.getElementById("style").value.trim();

    // Validation
    if(dest === "" || month === "" || duration === "" || style === ""){
        Swal.fire({
            icon: "error",
            title: "Missing Information",
            text: "Please fill all fields before submitting.",
        });
        return;
    }

    // Success message
    Swal.fire({
        icon: "success",
        title: "Submitted Successfully!",
        text: "We will help you plan your perfect trip.",
        confirmButtonColor: "#1E88E5"
    }).then(() => {
        // Redirect after success (optional)
        window.location.href = "home.php";
    });
});
</script>


<section class="ftco-section services-section" 
         style="position:relative; padding:80px 0; background:radial-gradient(circle at top left, rgba(30,136,229,0.12), transparent 55%), #ffffff;">
  <div class="container">

    <div class="row d-flex align-items-center">
      <!-- TEXT SIDE -->
      <div class="col-md-6 order-md-last heading-section pl-md-5 ftco-animate d-flex align-items-center">
        <div class="w-100">

          <span style="display:inline-block;
                       padding:6px 16px;
                       border-radius:999px;
                       background:rgba(30,136,229,0.08);
                       color:#1E88E5;
                       font-size:13px;
                       font-weight:600;
                       letter-spacing:1px;
                       text-transform:uppercase;">
            Discover Asia
          </span>

          <h2 style="margin-top:18px;
                     margin-bottom:12px;
                     font-size:34px;
                     font-weight:800;
                     color:#222;">
            Unveil the Wonders of Asia
          </h2>

          <p style="font-size:15px; color:#555; line-height:1.7; margin-bottom:10px;">
            From ancient temples to futuristic skylines, Asia blends deep tradition with modern wonder. 
            Every journey reveals new flavors, stories, and unforgettable views.
          </p>

          <p style="font-size:15px; color:#555; line-height:1.7;">
            Whether you dream of tranquil islands, crowded night markets, or misty mountain trails, 
            our curated experiences bring you closer to the heart of each destination.
          </p>

          <div style="display:flex; flex-wrap:wrap; gap:10px; margin-top:20px;">
            <div style="flex:1 1 140px; min-width:120px;">
              <p style="margin:0; font-size:13px; text-transform:uppercase; letter-spacing:1px; color:#777;">Handpicked Tours</p>
              <p style="margin:0; font-size:20px; font-weight:700; color:#1E88E5;">150+</p>
            </div>
            <div style="flex:1 1 140px; min-width:120px;">
              <p style="margin:0; font-size:13px; text-transform:uppercase; letter-spacing:1px; color:#777;">Happy Travelers</p>
              <p style="margin:0; font-size:20px; font-weight:700; color:#1E88E5;">10K+</p>
            </div>
          </div>

          <p style="margin-top:25px;">
            <a href="destination.php" 
               style="display:inline-block;
                      padding:12px 26px;
                      background:#1E88E5;
                      color:#ffffff;
                      font-size:15px;
                      font-weight:600;
                      border-radius:999px;
                      box-shadow:0 8px 20px rgba(30,136,229,0.35);
                      text-decoration:none;">
              Plan Your Asian Adventure
            </a>
          </p>

        </div>
      </div>

      <!-- CARDS SIDE -->
      <div class="col-md-6">
        <div class="row" style="margin:-10px;">

          <!-- Card 1 -->
          <div class="col-md-12 col-lg-6 d-flex align-self-stretch ftco-animate" style="padding:10px;">
            <div class="services d-block img"
                 style="position:relative;
                        width:100%;
                        min-height:220px;
                        border-radius:18px;
                        overflow:hidden;
                        background-image:url('images/services-1.jpg');
                        background-size:cover;
                        background-position:center;
                        box-shadow:0 12px 30px rgba(0,0,0,0.18);">
              
              <div style="position:absolute; inset:0; background:linear-gradient(135deg, rgba(0,0,0,0.45), rgba(0,0,0,0.15));"></div>
              
              <div class="icon d-flex align-items-center justify-content-center"
                   style="position:absolute;
                          top:16px; left:16px;
                          width:44px; height:44px;
                          border-radius:50%;
                          background:rgba(255,193,7,0.95);
                          color:#1E88E5;
                          font-size:22px;
                          z-index:2;">
                <span class="flaticon-paragliding"></span>
              </div>

              <div class="media-body"
                   style="position:absolute; left:18px; right:18px; bottom:18px; z-index:2; color:#ffffff;">
                <h3 class="heading mb-3" 
                    style="font-size:18px; font-weight:700; margin-bottom:6px;">
                  Thrilling Adventures
                </h3>
                <p style="font-size:14px; margin:0;">
                  Soar above mountains, dive into turquoise seas, and feel the rush of Asia’s wild side.
                </p>
              </div>
            </div>
          </div>

          <!-- Card 2 -->
          <div class="col-md-12 col-lg-6 d-flex align-self-stretch ftco-animate" style="padding:10px;">
            <div class="services d-block img"
                 style="position:relative;
                        width:100%;
                        min-height:220px;
                        border-radius:18px;
                        overflow:hidden;
                        background-image:url('images/services-2.jpg');
                        background-size:cover;
                        background-position:center;
                        box-shadow:0 12px 30px rgba(0,0,0,0.18);">
              
              <div style="position:absolute; inset:0; background:linear-gradient(135deg, rgba(0,0,0,0.5), rgba(30,136,229,0.45));"></div>
              
              <div class="icon d-flex align-items-center justify-content-center"
                   style="position:absolute;
                          top:16px; left:16px;
                          width:44px; height:44px;
                          border-radius:50%;
                          background:rgba(30,136,229,0.95);
                          color:#ffffff;
                          font-size:22px;
                          z-index:2;">
                <span class="flaticon-route"></span>
              </div>

              <div class="media-body"
                   style="position:absolute; left:18px; right:18px; bottom:18px; z-index:2; color:#ffffff;">
                <h3 class="heading mb-3" 
                    style="font-size:18px; font-weight:700; margin-bottom:6px;">
                  Seamless Travel Plans
                </h3>
                <p style="font-size:14px; margin:0;">
                  From flights to stays, we connect every stop so you can simply enjoy the journey.
                </p>
              </div>
            </div>
          </div>

          <!-- Card 3 -->
          <div class="col-md-12 col-lg-6 d-flex align-self-stretch ftco-animate" style="padding:10px;">
            <div class="services d-block img"
                 style="position:relative;
                        width:100%;
                        min-height:220px;
                        border-radius:18px;
                        overflow:hidden;
                        background-image:url('images/services-3.jpg');
                        background-size:cover;
                        background-position:center;
                        box-shadow:0 12px 30px rgba(0,0,0,0.18);">
              
              <div style="position:absolute; inset:0; background:linear-gradient(135deg, rgba(0,0,0,0.5), rgba(255,193,7,0.4));"></div>
              
              <div class="icon d-flex align-items-center justify-content-center"
                   style="position:absolute;
                          top:16px; left:16px;
                          width:44px; height:44px;
                          border-radius:50%;
                          background:#FFC107;
                          color:#1E88E5;
                          font-size:22px;
                          z-index:2;">
                <span class="flaticon-tour-guide"></span>
              </div>

              <div class="media-body"
                   style="position:absolute; left:18px; right:18px; bottom:18px; z-index:2; color:#ffffff;">
                <h3 class="heading mb-3" 
                    style="font-size:18px; font-weight:700; margin-bottom:6px;">
                  Expert Local Guides
                </h3>
                <p style="font-size:14px; margin:0;">
                  Meet the people who know every shortcut, story, and secret viewpoint.
                </p>
              </div>
            </div>
          </div>

          <!-- Card 4 -->
          <div class="col-md-12 col-lg-6 d-flex align-self-stretch ftco-animate" style="padding:10px;">
            <div class="services d-block img"
                 style="position:relative;
                        width:100%;
                        min-height:220px;
                        border-radius:18px;
                        overflow:hidden;
                        background-image:url('images/services-4.jpg');
                        background-size:cover;
                        background-position:center;
                        box-shadow:0 12px 30px rgba(0,0,0,0.18);">
              
              <div style="position:absolute; inset:0; background:linear-gradient(135deg, rgba(0,0,0,0.55), rgba(0,0,0,0.2));"></div>
              
              <div class="icon d-flex align-items-center justify-content-center"
                   style="position:absolute;
                          top:16px; left:16px;
                          width:44px; height:44px;
                          border-radius:50%;
                          background:rgba(255,255,255,0.96);
                          color:#1E88E5;
                          font-size:22px;
                          z-index:2;">
                <span class="flaticon-map"></span>
              </div>

              <div class="media-body"
                   style="position:absolute; left:18px; right:18px; bottom:18px; z-index:2; color:#ffffff;">
                <h3 class="heading mb-3" 
                    style="font-size:18px; font-weight:700; margin-bottom:6px;">
                  Tailored Itineraries
                </h3>
                <p style="font-size:14px; margin:0;">
                  Build a journey that fits your style—slow, fast, adventurous, or relaxed.
                </p>
              </div>
            </div>
          </div>

        </div>
      </div>

    </div>
  </div>
</section>


		<section class="ftco-section img ftco-select-destination" 
	style="background-image:url('images/bg_3.jpg'); background-size:cover; background-position:center; position:relative; padding:80px 0;">
	
	<!-- Overlay -->
	<div style="position:absolute; inset:0; background:linear-gradient(135deg, rgba(0,0,0,0.65), rgba(0,0,0,0.3)); z-index:1;"></div>

	<div class="container" style="position:relative; z-index:2;">
		<div class="row justify-content-center pb-4">
			<div class="col-md-12 heading-section text-center ftco-animate">
				<span style="display:inline-block;
							 padding:6px 18px;
							 border-radius:999px;
							 background:rgba(30,136,229,0.12);
							 color:#FFC107;
							 font-size:13px;
							 font-weight:600;
							 letter-spacing:1px;
							 text-transform:uppercase;">
					Handpicked by Best Travel Destinations
				</span>
				<h2 style="margin-top:18px;
						   font-size:34px;
						   font-weight:800;
						   color:#ffffff;
						   text-shadow:0 4px 14px rgba(0,0,0,0.45);">
					Select Your Dream Destination
				</h2>
				<p style="color:#e0e0e0; max-width:600px; margin:10px auto 0; font-size:15px; line-height:1.7;">
					Explore our curated collection of must-visit places across the globe — from iconic cities to hidden gems.
				</p>
			</div>
		</div>
	</div>

	<div class="container container-2" style="position:relative; z-index:2; margin-top:10px;">
		<div class="row">
			<div class="col-md-12">
				<div class="carousel-destination owl-carousel ftco-animate" 
					 style="padding-bottom:10px;">

					<?php
					include("admin/conn.php");

					$stmt = $conn->prepare("SELECT * FROM add_adver ORDER BY RAND() LIMIT 12");
					$stmt->execute();
					$result = $stmt->get_result();

					while ($row = $result->fetch_assoc()):
					?>
					
					<div class="item" style="padding:12px;">
						<div class="project-destination" 
							 style="position:relative;
									border-radius:20px;
									overflow:hidden;
									box-shadow:0 14px 30px rgba(0,0,0,0.35);
									background:#000;">
							
							<a href="details.php?category=<?= $row['id']; ?>" 
							   class="img"
							   style="display:block;
									  position:relative;
									  height:380px;
									  width:100%;
									  background-image:url('admin/pic/<?= $row['product_img']; ?>');
									  background-size:cover;
									  background-position:center;">
								
								<!-- Gradient overlay -->
								<div style="position:absolute; inset:0; 
											background:linear-gradient(to top, rgba(0,0,0,0.85), rgba(0,0,0,0.25));">
								</div>
								
								<!-- Country badge -->
								<div style="position:absolute; top:16px; left:16px; z-index:2;">
									<span style="display:inline-block;
												 padding:6px 12px;
												 font-size:12px;
												 font-weight:600;
												 letter-spacing:0.5px;
												 text-transform:uppercase;
												 border-radius:999px;
												 background:rgba(255,193,7,0.95);
												 color:#1E88E5;">
										<?= $row['country']; ?>
									</span>
								</div>

								<!-- Optional tag / badge on the right -->
								<div style="position:absolute; top:16px; right:16px; z-index:2;">
									<span style="display:inline-block;
												 padding:6px 10px;
												 font-size:11px;
												 font-weight:600;
												 text-transform:uppercase;
												 border-radius:999px;
												 background:rgba(30,136,229,0.9);
												 color:#ffffff;">
										Top Pick
									</span>
								</div>

								<!-- Bottom text area -->
								<div class="text" 
									 style="position:absolute; left:18px; right:18px; bottom:16px; z-index:2; color:#ffffff;">
									
									<h3 style="font-size:18px; font-weight:700; margin-bottom:6px;">
										<?= $row['title']; ?>
									</h3>
									
									<!-- Meta line -->
									
								</div>
							</a>

						</div>
					</div>

					<?php endwhile; ?>

				</div>
			</div>
		</div>
	</div>
</section>


	<section class="ftco-section dest-section" style="padding:80px 0; background:#f7f8fc;">
  <div class="container" style="max-width:1400px;">

    <!-- Heading -->
    <div class="row justify-content-center pb-4">
      <div class="col-md-12 text-center ftco-animate">
        <div style="display:inline-block; padding:6px 18px; border-radius:50px; background:#e8f2ff; color:#1E88E5; font-weight:600; font-size:13px; letter-spacing:1px;">
          Destinations
        </div>

        <h2 style="margin-top:18px; font-size:34px; font-weight:800; color:#222;">
          Explore Tour Destinations
        </h2>

        <p style="max-width:620px; margin:8px auto 0; color:#555; font-size:15px;">
          Ultra-curated destinations packed with culture, scenery and unforgettable experiences.
        </p>
      </div>
    </div>

    <!-- DESTINATION GRID -->
    <div class="row">
      <?php
        include("admin/conn.php");

        $stmt = $conn->prepare("SELECT * FROM add_adver ORDER BY RAND() LIMIT 9");
        $stmt->execute();
        $result = $stmt->get_result();

        // small tag list for variety
        $tags = ['Iconic Landmark','Hidden Gem','Family Friendly','Cultural Hotspot','Top Rated','Perfect Weekend Escape'];

        while ($row = $result->fetch_assoc()):
          $tag = $tags[array_rand($tags)];
          $rating = rand(44,50) / 10; // 4.4 - 5.0
      ?>

      <div class="col-md-4 ftco-animate mb-4">
        <div class="destination-card">
          <a href="details.php?category=<?= $row['id']; ?>" class="destination-image" style="background-image:url('admin/pic/<?= $row['product_img']; ?>');">
            <span class="destination-badge"><?= $tag; ?></span>
          </a>

          <div class="destination-body">
            <p class="destination-country">
              <i class="fa fa-map-marker"></i> <?= $row['country']; ?>
            </p>

            <h3 class="destination-title">
              <a href="details.php?category=<?= $row['id']; ?>"><?= $row['title']; ?></a>
            </h3>

            <div class="destination-meta">
              <span><i class="fa fa-star"></i> <?= number_format($rating,1); ?> / 5</span>
              <span><i class="fa fa-suitcase"></i> Popular experience</span>
            </div>

            <div class="destination-footer">
              <span class="destination-tagline">
                Inspiring views, local flavors & memorable stories.
              </span>
              <a href="details.php?category=<?= $row['id']; ?>" class="btn btn-outline-primary btn-sm destination-btn">
                View Details
              </a>
            </div>
          </div>
        </div>
      </div>

      <?php endwhile; ?>
    </div>

  </div>
</section>

<style>
.dest-section .destination-card{
  background:#ffffff;
  border-radius:18px;
  overflow:hidden;
  box-shadow:0 10px 25px rgba(0,0,0,0.08);
  transition:transform .25s ease, box-shadow .25s ease;
  height:100%;
  display:flex;
  flex-direction:column;
}
.dest-section .destination-card:hover{
  transform:translateY(-6px);
  box-shadow:0 18px 40px rgba(0,0,0,0.15);
}
.dest-section .destination-image{
  display:block;
  position:relative;
  padding-top:62%;
  background-size:cover;
  background-position:center;
}
.dest-section .destination-image::after{
  content:"";
  position:absolute;
  inset:0;
  background:linear-gradient(to top, rgba(0,0,0,0.55), transparent);
}
.dest-section .destination-badge{
  position:absolute;
  left:14px;
  bottom:14px;
  z-index:2;
  padding:6px 12px;
  border-radius:999px;
  background:rgba(255,255,255,0.15);
  backdrop-filter:blur(8px);
  color:#fff;
  font-size:11px;
  text-transform:uppercase;
  letter-spacing:.08em;
}
.dest-section .destination-body{
  padding:16px 18px 14px;
  display:flex;
  flex-direction:column;
  flex:1;
}
.dest-section .destination-country{
  margin-bottom:4px;
  font-size:13px;
  color:#888;
}
.dest-section .destination-country i{
  color:#ff7043;
  margin-right:5px;
}
.dest-section .destination-title{
  font-size:18px;
  font-weight:700;
  margin:0 0 10px;
}
.dest-section .destination-title a{
  color:#222;
  text-decoration:none;
}
.dest-section .destination-title a:hover{
  color:#1E88E5;
}
.dest-section .destination-meta{
  display:flex;
  flex-wrap:wrap;
  gap:12px;
  font-size:12px;
  text-transform:uppercase;
  letter-spacing:.08em;
  color:#6c757d;
  margin-bottom:12px;
}
.dest-section .destination-meta i{
  margin-right:4px;
  color:#ffb300;
}
.dest-section .destination-footer{
  margin-top:auto;
  display:flex;
  justify-content:space-between;
  align-items:center;
  gap:10px;
  font-size:13px;
}
.dest-section .destination-tagline{
  color:#777;
  max-width:60%;
}
.dest-section .destination-btn{
  border-radius:999px;
  font-size:13px;
  padding:6px 16px;
}

/* Responsive tweaks */
@media (max-width:767.98px){
  .dest-section .destination-footer{
    flex-direction:column;
    align-items:flex-start;
  }
  .dest-section .destination-tagline{
    max-width:100%;
  }
}
</style>


		<!-- ABOUT HERO BANNER -->
<section class="ftco-section ftco-about img"
	style="
		background-image:url('images/bg_5.jpg');
		background-size:cover;
		background-position:center;
		position:relative;
		padding:90px 0 120px 0;">
	
	<!-- Dark overlay -->
	<div style="
		position:absolute;
		inset:0;
		background:linear-gradient(135deg, rgba(0,0,0,0.7), rgba(0,0,0,0.35));">
	</div>

	<div class="container py-md-5" style="position:relative; z-index:2;">
		<div class="row py-md-4">
			<div class="col-md-12 d-flex flex-column align-items-center justify-content-center text-center">
				
				<span style="
					display:inline-block;
					padding:6px 18px;
					border-radius:999px;
					background:rgba(255,255,255,0.12);
					color:#FFC107;
					font-size:13px;
					font-weight:600;
					letter-spacing:1px;
					text-transform:uppercase;">
					About Best Travel Destinations
				</span>

				<h1 style="
					margin-top:18px;
					font-size:40px;
					font-weight:800;
					color:#ffffff;">
					Redefining Asian Travel Experiences
				</h1>

				<p style="
					max-width:640px;
					margin:12px auto 0;
					color:#f0f0f0;
					font-size:15px;
					line-height:1.7;">
					Thoughtfully crafted journeys across Asia, blending iconic landmarks with hidden local gems.
				</p>
			</div>
		</div>
	</div>
</section>

<!-- FLOATING ABOUT CARD SECTION -->
<section class="ftco-section ftco-about ftco-no-pt img" style="background:#f7f9fc; padding-top:0; padding-bottom:0px;">
	<div class="container" style="margin-top:-80px;">
		<div class="row d-flex justify-content-center">
			<div class="col-md-11 about-intro">
				
				<!-- Main card -->
				

			</div>
		</div>
	</div>
</section>


	


		<br>
		<br>

	

		<?php include "footer.php"; ?>	