<?php include 'header.php'; ?>
<!-- END nav -->
<!-- HERO: Tours List -->
<section class="hero-wrap hero-tours" style="background-image: url('images/bg_1.jpg');">
  <div class="hero-overlay"></div>
  <div class="container h-100">
    <div class="row h-100 align-items-center justify-content-center text-center">
      <div class="col-md-10">
        <p class="breadcrumbs mb-2">
          <span class="mr-2"><a href="home.php">Home <i class="fa fa-chevron-right"></i></a></span>
          <span>Tour List <i class="fa fa-chevron-right"></i></span>
        </p>
        <h1 class="hero-title mb-3">Find Your Next Journey</h1>
        <p class="hero-subtitle mb-4">
          Handpicked Asia tours, crafted for explorers, families & honeymooners.
        </p>

        <!-- Optional mini filter (non-functional if you don’t process it) -->
        <!-- <form class="hero-filter d-flex flex-wrap justify-content-center">
          <div class="form-group mb-2 mb-md-0 mr-md-2">
            <input type="text" class="form-control" placeholder="Search by place or tour name">
          </div>
          <div class="form-group mb-2 mb-md-0 mr-md-2">
            <select class="form-control">
              <option selected>Any Region</option>
              <option>South Asia</option>
              <option>Southeast Asia</option>
              <option>East Asia</option>
            </select>
          </div>
          <button type="submit" class="btn btn-primary px-4">Explore Tours</button>
        </form> -->
      </div>
    </div>
  </div>
</section>

<!-- TOURS GRID -->
<section class="ftco-section tours-grid-section">
  <div class="container" style="max-width: 1400px;">
    <div class="row">
      <?php
        include("admin/conn.php");

        $stmt = $conn->prepare("SELECT * FROM add_adver ORDER BY RAND() LIMIT 30");
        $stmt->execute();
        $result = $stmt->get_result();

        while ($row = $result->fetch_assoc()):
      ?>

      <div class="col-md-4 mb-4">
        <div class="tour-card">
          <div class="tour-image-wrapper">
            <a href="details.php?category=<?= $row['id']; ?>" class="tour-image" style="background-image: url('admin/pic/<?= $row['product_img']; ?>');">
              <span class="tour-badge">Trending</span>
              <span class="tour-country"><i class="fa fa-map-marker"></i> <?= $row['country']; ?></span>
            </a>
          </div>
          <div class="tour-content">
            <h3 class="tour-title">
              <a href="details.php?category=<?= $row['id']; ?>"><?= $row['title']; ?></a>
            </h3>

            <!-- Simple meta row instead of days/nights & rooms -->
            <div class="tour-meta">
              <span><i class="fa fa-globe"></i> Guided experience</span>
              <span><i class="fa fa-users"></i> Small group</span>
            </div>

            <div class="tour-footer">
              <div class="tour-tagline">
                Perfect for first-time visitors & culture lovers.
              </div>
              <a href="details.php?category=<?= $row['id']; ?>" class="btn btn-outline-primary btn-sm">
                View Details
              </a>
            </div>
          </div>
        </div>
      </div>

      <?php endwhile; ?>
    </div>
  </div>
</section>

<!-- STYLES FOR NEW DESIGN -->
<style>
/* Hero */
.hero-tours {
  position: relative;
  background-size: cover;
  background-position: center;
  min-height: 60vh;
  display: flex;
  align-items: center;
}
.hero-overlay {
  position: absolute;
  inset: 0;
  background: linear-gradient(135deg, rgba(0,0,0,0.65), rgba(0,0,0,0.35));
}
.hero-tours .container {
  position: relative;
  z-index: 2;
}
.hero-title {
  font-size: 42px;
  font-weight: 700;
  color: #fff;
}
.hero-subtitle {
  color: rgba(255,255,255,0.8);
  max-width: 600px;
  margin: 0 auto;
}
.hero-filter .form-control {
  min-width: 220px;
  border-radius: 30px;
}
.hero-filter .btn {
  border-radius: 30px;
}

/* Tours cards */
.tours-grid-section {
  background: #f7f8fc;
}
.tour-card {
  background: #fff;
  border-radius: 14px;
  overflow: hidden;
  box-shadow: 0 10px 25px rgba(0,0,0,0.07);
  transition: transform .25s ease, box-shadow .25s ease;
  height: 100%;
  display: flex;
  flex-direction: column;
}
.tour-card:hover {
  transform: translateY(-6px);
  box-shadow: 0 16px 35px rgba(0,0,0,0.12);
}
.tour-image-wrapper {
  position: relative;
  overflow: hidden;
}
.tour-image {
  display: block;
  background-size: cover;
  background-position: center;
  padding-top: 62%; /* image ratio */
  position: relative;
}
.tour-image::after {
  content: "";
  position: absolute;
  inset: 0;
  background: linear-gradient(to top, rgba(0,0,0,0.45), transparent);
}
.tour-badge {
  position: absolute;
  top: 14px;
  left: 14px;
  z-index: 2;
  background: #ff6b35;
  color: #fff;
  font-size: 11px;
  text-transform: uppercase;
  letter-spacing: .08em;
  padding: 6px 10px;
  border-radius: 20px;
}
.tour-country {
  position: absolute;
  bottom: 12px;
  left: 14px;
  z-index: 2;
  background: rgba(0,0,0,0.55);
  color: #fff;
  font-size: 13px;
  padding: 6px 12px;
  border-radius: 20px;
}
.tour-country i {
  margin-right: 6px;
}
.tour-content {
  padding: 18px 20px 16px;
  display: flex;
  flex-direction: column;
  flex: 1;
}
.tour-title {
  font-size: 18px;
  margin-bottom: 10px;
}
.tour-title a {
  color: #222;
  text-decoration: none;
}
.tour-title a:hover {
  color: #ff6b35;
}
.tour-meta {
  display: flex;
  flex-wrap: wrap;
  font-size: 12px;
  text-transform: uppercase;
  letter-spacing: .08em;
  color: #6c757d;
  gap: 12px;
  margin-bottom: 14px;
}
.tour-meta i {
  margin-right: 4px;
}
.tour-footer {
  margin-top: auto;
  display: flex;
  justify-content: space-between;
  align-items: center;
  font-size: 13px;
}
.tour-tagline {
  color: #6c757d;
  max-width: 60%;
}
.tour-footer .btn {
  border-radius: 20px;
  padding: 6px 16px;
  font-size: 13px;
}

/* Responsive tweaks */
@media (max-width: 767.98px) {
  .hero-title {
    font-size: 30px;
  }
  .hero-subtitle {
    font-size: 14px;
  }
  .tour-footer {
    flex-direction: column;
    align-items: flex-start;
    gap: 8px;
  }
  .tour-tagline {
    max-width: 100%;
  }
}
</style>




<?php include 'footer.php'; ?>